/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import Beans.beansComprasClases;
import Beans.beansEquiposCapacidades;
import Beans.beansGenericoString;
import Beans.beansPreparaciones;
import Beans.beansPresentacionesVentas;
import Beans.beansTipoDocumento;
import Cafe.FrameMain;
import SortTable.HeaderListener;
import SortTable.SortButtonRenderer;
import SortTable.SortableTableModel;
import Tools.ApplicationMessages;
import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GeneralTools {
    public String IMAGEN_NUEVO = "Imagenes/eliminar.png";
    public String IMAGEN_AGREGAR = "Imagenes/add.png";
    public String IMAGEN_EDITAR = "Imagenes/edit.png";
    public String IMAGEN_BORRAR = "Imagenes/add.png";
    public String IMAGEN_OK = "Imagenes/Ok.gif";
    public String IMAGEN_OK14 = "Imagenes/Ok14.gif";
    public String IMAGEN_OKNO = "Imagenes/OkNo.gif";
    public String IMAGEN_BUSCAR = "Imagenes/find.png";
    public String IMAGEN_RELOAD = "Imagenes/refresh.png";
    public String IMAGEN_ALERTA = "Imagenes/warning.png";
    public String IMAGEN_IMPRIMIR = "Imagenes/printer3.png";
    public String IMAGEN_GUARDAR = "Imagenes/disk_blue.png";
    public String IMAGEN_CERRAR = "Imagenes/delete.png";
    public String IMAGEN_PREVIEW = "Imagenes/PrintPreview16.gif";
    public String IMAGEN_PEDIDOS = "Imagenes/Alerta.gif";
    public String IMAGEN_NUEVAFACTURA = "Imagenes/money2_add.png";
    public String IMAGEN_ALERTA_BLANCA = "Imagenes/AlertaBlanca.png";
    public String IMAGEN_PREGUNTA = "Imagenes/Pregunta.gif";
    public String IMAGEN_BUSQUEDA_RECIBOS = "Imagenes/Save16.gif";
    public String IMAGEN_REPORTES = "Imagenes/Reporte.jpg";
    public String IMAGEN_LOADING = "Imagenes/Loading.jpg";
    public String IMAGEN_RESULTADOS = "Imagenes/ExamenesResultados.jpg";
    public String DIRECCION_REPORTES = "c:/ACOWIN/Reportes/";
    public String DIRECCION_REPORTES_BUSQUEDA = "c:/ACOWIN/Reportes/";
    public String IMAGEN_DERECHA = "Imagenes/navigate_right.png";
    public String IMAGEN_DERECHA2 = "Imagenes/navigate_right2.png";
    public String IMAGEN_IZQUIERDA = "Imagenes/navigate_left.png";
    public String IMAGEN_IZQUIERDA2 = "Imagenes/navigate_left2.png";
    public double IVA = 0.13;
    public double RETENCION = 0.01;
    public String IVA_CREDITO = "144.01";
    public String FOVIAL_COMPRA = "411.01.038";
    public String IVA_DEBITO_CONSUMIDORES = "144.01";
    public String IVA_DEBIDO_CONTRIBUYENTES = "144.01";
    public String IMAGEN_NUEVO_FICHEROS = "Imagenes/index_add.png";
    public String IMAGEN_EDITAR_FICHEROS = "Imagenes/index_edit.png";
    public String IMAGEN_BORRAR_FICHEROS = "Imagenes/index_delete.png";
    public String IMAGEN_OK_FICHEROS = "Imagenes/check2.png";
    private ApplicationMessages Ap = new ApplicationMessages();
    public static Image iconoFrame = new ImageIcon(GeneralTools.class.getResource("/Cafe/Imagenes/logoCafe.png")).getImage();

    public String underlineString(String s, int key) {
        String cad = "<html><font>";
        for (int i = 0; i < s.length(); ++i) {
            cad = i == key - 1 ? cad + "<u>" + s.substring(i, i + 1) + "</u>" : cad + s.substring(i, i + 1) + "";
        }
        return cad + "</font></html>";
    }

    public boolean validarCuentaIva(Connection conn, String idEmpresa, String codigo) {
        try {
            boolean band = false;
            String sql = "select id_cuenta from aco_cuentas where id_empresa = " + idEmpresa + " and iva = 'Si'";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (!codigo.equals(rs.getString("id_cuenta"))) continue;
                band = true;
            }
            rs.close();
            stmt.close();
            return band;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public boolean validarCuentaBanco(Connection conn, String idEmpresa, String codigo) {
        try {
            boolean band = false;
            String sql = "select id_cuenta from aco_cuentas where id_empresa = " + idEmpresa + " and bancos = 'Si'";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (!codigo.equals(rs.getString("id_cuenta"))) continue;
                band = true;
            }
            rs.close();
            stmt.close();
            return band;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public void centerFrame(Frame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void centerFrame(JDialog frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public boolean IsNumber(KeyEvent e) {
        return e.getKeyChar() == '1' || e.getKeyChar() == '2' || e.getKeyChar() == '3' || e.getKeyChar() == '4' || e.getKeyChar() == '5' || e.getKeyChar() == '6' || e.getKeyChar() == '7' || e.getKeyChar() == '8' || e.getKeyChar() == '9' || e.getKeyChar() == '0';
    }

    public boolean IsNumber(String Cadena) {
        boolean band = false;
        boolean puntos = false;
        if (Cadena.length() == 0) {
            return false;
        }
        for (int i = 0; i < Cadena.length(); ++i) {
            if (!(Cadena.substring(i, i + 1).equals("0") || Cadena.substring(i, i + 1).equals("1") || Cadena.substring(i, i + 1).equals("2") || Cadena.substring(i, i + 1).equals("3") || Cadena.substring(i, i + 1).equals("4") || Cadena.substring(i, i + 1).equals("5") || Cadena.substring(i, i + 1).equals("6") || Cadena.substring(i, i + 1).equals("7") || Cadena.substring(i, i + 1).equals("8") || Cadena.substring(i, i + 1).equals("9"))) {
                band = false;
                return band;
            }
            band = true;
        }
        return true;
    }

    public String myNvl(String cad) {
        if (cad == null) {
            return "";
        }
        return cad;
    }

    public String ConvertirMesATextoCompleto(String cadena) {
        if (cadena.substring(5, 7).equals("01")) {
            return "Enero";
        }
        if (cadena.substring(5, 7).equals("02")) {
            return "Febrero";
        }
        if (cadena.substring(5, 7).equals("03")) {
            return "Marzo";
        }
        if (cadena.substring(5, 7).equals("04")) {
            return "Abril";
        }
        if (cadena.substring(5, 7).equals("05")) {
            return "Mayo";
        }
        if (cadena.substring(5, 7).equals("06")) {
            return "Junio";
        }
        if (cadena.substring(5, 7).equals("07")) {
            return "Julio";
        }
        if (cadena.substring(5, 7).equals("08")) {
            return "Agosto";
        }
        if (cadena.substring(5, 7).equals("09")) {
            return "Septiembre";
        }
        if (cadena.substring(5, 7).equals("10")) {
            return "Octubre";
        }
        if (cadena.substring(5, 7).equals("11")) {
            return "Noviembre";
        }
        if (cadena.substring(5, 7).equals("12")) {
            return "Diciembre";
        }
        return "";
    }

    public boolean IsCurrencyByJava(String Cadena) {
        boolean band = false;
        try {
            Double.parseDouble(Cadena.replaceAll(",", ""));
            band = true;
        }
        catch (Exception e) {
            band = false;
        }
        return band;
    }

    public boolean IsCurrency(String Cadena) {
        boolean band = false;
        int puntos = 0;
        if (Cadena.length() == 0) {
            return false;
        }
        for (int i = 0; i < Cadena.length(); ++i) {
            if (Cadena.substring(i, i + 1).equals("0") || Cadena.substring(i, i + 1).equals("1") || Cadena.substring(i, i + 1).equals("2") || Cadena.substring(i, i + 1).equals("3") || Cadena.substring(i, i + 1).equals("4") || Cadena.substring(i, i + 1).equals("5") || Cadena.substring(i, i + 1).equals("6") || Cadena.substring(i, i + 1).equals("7") || Cadena.substring(i, i + 1).equals("8") || Cadena.substring(i, i + 1).equals("9") || Cadena.substring(i, i + 1).equals(".")) {
                band = true;
                if (Cadena.substring(i, i + 1).equals(".")) {
                    ++puntos;
                }
                if (puntos <= 1) continue;
                return false;
            }
            band = false;
            return band;
        }
        return true;
    }

    public String ObtenerHoraMaquima(int dias, String Formato) {
        Date hoy = new Date();
        long a = hoy.getTime() + (long)(dias * 86400000);
        String FechaNew = new SimpleDateFormat(Formato).format(new Date(a));
        return FechaNew;
    }

    public String ObtenerFecha(int dias, Connection conn) {
        String FechaNew = "";
        String sql = "select date_add(curdate() , INTERVAL " + dias + " DAY) as fecha";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("fecha");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return FechaNew.substring(0, 4) + "/" + FechaNew.substring(5, 7) + "/" + FechaNew.substring(8, 10);
    }

    public static String ObtenerFecha(String fecha, int dias, Connection conn) {
        String FechaNew = "";
        String sql = "select date_add('" + fecha + "' , INTERVAL " + dias + " DAY) as fecha";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("fecha");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return FechaNew.substring(0, 4) + "/" + FechaNew.substring(5, 7) + "/" + FechaNew.substring(8, 10);
    }

    public String[] ObtenerEdad(String FechaNac, Connection conn) {
        String[] FechaNew = new String[2];
        String sql = "select (DateDiff('d', '" + FechaNac + "', Date()))/365.25  as fecha,(DateDiff('d', '" + FechaNac + "', Date()))/365.25  as fecha1";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew[0] = Integer.toString(rs.getInt("fecha"));
                FechaNew[1] = Double.toString(rs.getDouble("fecha1") - Double.parseDouble(FechaNew[0]));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return FechaNew;
    }

    public int ObtenerFechaMayor(String Fecha1, String Fecha2, Connection conn) {
        String FechaNew = "";
        String sql = "select DATEDIFF('" + Fecha2 + "','" + Fecha1 + "') as fecha";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("fecha");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.parseInt(FechaNew);
    }

    public String ObtenerFechaUltimoMes(String Fecha, Connection conn) {
        String FechaNew = "";
        String sql = "select LAST_DAY('" + Fecha + "') as fecha";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("fecha");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FechaNew.substring(0, 4) + "/" + FechaNew.substring(5, 7) + "/" + FechaNew.substring(8, 10);
    }

    public String ObtenerFechaHora(int dias, Connection conn) {
        String FechaNew = "";
        String sql = "select concat(curdate() + " + dias + ",' ',curtime()) as fecha";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("fecha");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FechaNew.substring(0, 4) + "/" + FechaNew.substring(4, 6) + "/" + FechaNew.substring(6, 8) + FechaNew.substring(8);
    }

    public String GetWeek(int dias, Connection conn) {
        String FechaNew = "";
        String sql = "select curdate() + " + dias + " as fecha";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("fecha");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Integer.parseInt(FechaNew.substring(0, 2)) >= 1 && Integer.parseInt(FechaNew.substring(0, 2)) <= 7) {
            return "1";
        }
        if (Integer.parseInt(FechaNew.substring(0, 2)) >= 8 && Integer.parseInt(FechaNew.substring(0, 2)) <= 15) {
            return "2";
        }
        if (Integer.parseInt(FechaNew.substring(0, 2)) >= 16 && Integer.parseInt(FechaNew.substring(0, 2)) <= 23) {
            return "3";
        }
        if (Integer.parseInt(FechaNew.substring(0, 2)) >= 24 && Integer.parseInt(FechaNew.substring(0, 2)) <= 31) {
            return "4";
        }
        return FechaNew;
    }

    public String obtener_dia_semana(int dias, Connection conn) {
        String FechaNew = "";
        String sql = "select date_format(curdate() + " + dias + ",' %a') as fecha";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("fecha");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (FechaNew.toUpperCase().equals("MON") || FechaNew.toUpperCase().equals("LUN")) {
            return "1";
        }
        if (FechaNew.toUpperCase().equals("TUE") || FechaNew.toUpperCase().equals("MAR")) {
            return "2";
        }
        if (FechaNew.toUpperCase().equals("WED") || FechaNew.toUpperCase().equals("MIE")) {
            return "3";
        }
        if (FechaNew.toUpperCase().equals("THU") || FechaNew.toUpperCase().equals("JUE")) {
            return "4";
        }
        if (FechaNew.toUpperCase().equals("FRI") || FechaNew.toUpperCase().equals("VIE")) {
            return "5";
        }
        if (FechaNew.toUpperCase().equals("SAT") || FechaNew.toUpperCase().equals("SAB")) {
            return "6";
        }
        if (FechaNew.toUpperCase().equals("SUN") || FechaNew.toUpperCase().equals("DOM")) {
            return "7";
        }
        return "0";
    }

    public String ConvertirMesATexto(String cadena) {
        if (cadena.substring(5, 7).equals("01")) {
            return "Enero";
        }
        if (cadena.substring(5, 7).equals("02")) {
            return "Febrero";
        }
        if (cadena.substring(5, 7).equals("03")) {
            return "Marzo";
        }
        if (cadena.substring(5, 7).equals("04")) {
            return "Abril";
        }
        if (cadena.substring(5, 7).equals("05")) {
            return "Mayo";
        }
        if (cadena.substring(5, 7).equals("06")) {
            return "Junio";
        }
        if (cadena.substring(5, 7).equals("07")) {
            return "Julio";
        }
        if (cadena.substring(5, 7).equals("08")) {
            return "Agosto";
        }
        if (cadena.substring(5, 7).equals("09")) {
            return "Septiembre";
        }
        if (cadena.substring(5, 7).equals("10")) {
            return "Octubre";
        }
        if (cadena.substring(5, 7).equals("11")) {
            return "Noviembre";
        }
        if (cadena.substring(5, 7).equals("12")) {
            return "Diciembre";
        }
        return "";
    }

    public String FormatValue(String pattern, double value) {
        DecimalFormat myFormatter = new DecimalFormat("###,###,###,###.##");
        String output = myFormatter.format(value);
        if (myFormatter.getDecimalFormatSymbols().getGroupingSeparator() == ',') {
            if (output.indexOf(".") < 0) {
                output = output + ".00";
            } else if (output.substring(output.indexOf("."), output.length()).length() == 2) {
                output = output + "0";
            }
        } else {
            if (output.indexOf(",") < 0) {
                output = output + ",00";
            } else if (output.substring(output.indexOf(","), output.length()).length() == 2) {
                output = output + "0";
            }
            output = output.replace(',', 'c');
            output = output.replace('.', ',');
            output = output.replace('c', '.');
        }
        return output;
    }

    public String Underline(String Cadena, int posicion) {
        String cad = "<html><font>";
        for (int i = 0; i < Cadena.length(); ++i) {
            cad = i == posicion ? cad + "<u>" + Cadena.substring(i, i + 1) + "</u>" : cad + Cadena.substring(i, i + 1);
        }
        cad = cad + "</font></html>";
        return cad;
    }

    public String RellenarCadena(String Cadena, int Longitud, String Lado, String Relleno) {
        Longitud -= Cadena.length();
        for (int i = 0; i < Longitud; ++i) {
            Cadena = Lado.equals("I") ? Relleno + Cadena : Cadena + Relleno;
        }
        return Cadena;
    }

    public String RellenarCadenaCantidad(String Cadena, int Longitud, String Lado, String Relleno) {
        int i;
        String CadModificada = Cadena;
        Cadena = "";
        int contador = 0;
        boolean band = false;
        for (i = 0; i < CadModificada.length(); ++i) {
            if (!CadModificada.substring(i, i + 1).equals(".")) {
                Cadena = Cadena + CadModificada.substring(i, i + 1);
            }
            if (band) {
                ++contador;
            }
            if (!CadModificada.substring(i, i + 1).equals(".")) continue;
            band = true;
        }
        if (contador == 0) {
            Cadena = Cadena + "00";
        }
        if (contador == 1) {
            Cadena = Cadena + "0";
        }
        Longitud -= Cadena.length();
        for (i = 0; i < Longitud; ++i) {
            Cadena = Lado.equals("I") ? Relleno + Cadena : Cadena + Relleno;
        }
        return Cadena;
    }

    public void WriteLog(String Error, Connection conn) {
        try {
            File f = new File("c://Construccion/" + this.ObtenerFechaHora(0, conn).replace('/', '-').replace(' ', '_').replace(':', '-') + ".txt");
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter file = new FileWriter(f);
            file.write(Error);
            file.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String ConvertirNumerosATexto(String Cadena) {
        Vector<String> CadenaVector = new Vector<String>();
        String Elemento = "";
        String CadenaValue = "";
        String CadenaDolares = "";
        boolean band = true;
        try {
            CadenaDolares = Cadena.indexOf(".") >= 0 ? this.RellenarCadena(Cadena.substring(0, Cadena.indexOf(".")), 9, "I", "0") : this.RellenarCadena(Cadena, 9, "I", "0");
            String CadenaCentavos = "";
            if (Cadena.indexOf(".") >= 0) {
                CadenaCentavos = Cadena.substring(Cadena.indexOf(".") + 1, Cadena.length());
            }
            if (CadenaCentavos.length() == 1) {
                CadenaCentavos = CadenaCentavos + "0";
            }
            for (int i = 0; i < CadenaDolares.length(); ++i) {
                CadenaVector.add(CadenaDolares.substring(i, i + 1));
            }
            String All = "";
            for (int i = 0; i < CadenaVector.size(); i += 3) {
                if (!CadenaValue.equals("") && i == 3) {
                    All = All + " Millones ";
                }
                if (!CadenaValue.equals("") && i == 6) {
                    All = All + " Mil ";
                }
                CadenaValue = "";
                band = true;
                Elemento = CadenaVector.elementAt(i).toString();
                if (Elemento.equals("1")) {
                    CadenaValue = CadenaVector.elementAt(i + 1).toString().equals("0") && CadenaVector.elementAt(i + 2).toString().equals("0") ? "Cien " + CadenaValue : "Ciento " + CadenaValue;
                }
                if (Elemento.equals("2")) {
                    CadenaValue = "Doscientos " + CadenaValue;
                }
                if (Elemento.equals("3")) {
                    CadenaValue = "Trecientos " + CadenaValue;
                }
                if (Elemento.equals("4")) {
                    CadenaValue = "Cuatrocientos " + CadenaValue;
                }
                if (Elemento.equals("5")) {
                    CadenaValue = "Quinientos " + CadenaValue;
                }
                if (Elemento.equals("6")) {
                    CadenaValue = "Seiscientos " + CadenaValue;
                }
                if (Elemento.equals("7")) {
                    CadenaValue = "Setecientos " + CadenaValue;
                }
                if (Elemento.equals("8")) {
                    CadenaValue = "Ochocientos " + CadenaValue;
                }
                if (Elemento.equals("9")) {
                    CadenaValue = "Novecientos" + CadenaValue;
                }
                if ((Elemento = CadenaVector.elementAt(i + 1).toString()).equals("1")) {
                    band = false;
                    if (CadenaVector.elementAt(i + 2).toString().equals("0")) {
                        CadenaValue = CadenaValue + "Diez ";
                    }
                    if (CadenaVector.elementAt(i + 2).toString().equals("1")) {
                        CadenaValue = CadenaValue + "Once ";
                    }
                    if (CadenaVector.elementAt(i + 2).toString().equals("2")) {
                        CadenaValue = CadenaValue + "Doce ";
                    }
                    if (CadenaVector.elementAt(i + 2).toString().equals("3")) {
                        CadenaValue = CadenaValue + "Trece ";
                    }
                    if (CadenaVector.elementAt(i + 2).toString().equals("4")) {
                        CadenaValue = CadenaValue + "Catorce ";
                    }
                    if (CadenaVector.elementAt(i + 2).toString().equals("5")) {
                        CadenaValue = CadenaValue + "Quince ";
                    }
                    if (Integer.parseInt(CadenaVector.elementAt(i + 2).toString()) > 5) {
                        CadenaValue = CadenaValue + "dieci";
                        band = true;
                    }
                }
                if (Elemento.equals("2")) {
                    CadenaValue = CadenaValue + "Veinti";
                }
                if (Elemento.equals("3")) {
                    CadenaValue = CadenaValue + "Treinta y ";
                }
                if (Elemento.equals("4")) {
                    CadenaValue = CadenaValue + "Cuarenta y ";
                }
                if (Elemento.equals("5")) {
                    CadenaValue = CadenaValue + "Cincuenta y ";
                }
                if (Elemento.equals("6")) {
                    CadenaValue = CadenaValue + "Sesenta y ";
                }
                if (Elemento.equals("7")) {
                    CadenaValue = CadenaValue + "Setenta y ";
                }
                if (Elemento.equals("8")) {
                    CadenaValue = CadenaValue + "Ochenta y ";
                }
                if (Elemento.equals("9")) {
                    CadenaValue = CadenaValue + "Noventa y ";
                }
                Elemento = CadenaVector.elementAt(i + 2).toString();
                if (band) {
                    if (Elemento.equals("1")) {
                        CadenaValue = CadenaValue + "Un";
                    }
                    if (Elemento.equals("2")) {
                        CadenaValue = CadenaValue + "Dos";
                    }
                    if (Elemento.equals("3")) {
                        CadenaValue = CadenaValue + "Tres";
                    }
                    if (Elemento.equals("4")) {
                        CadenaValue = CadenaValue + "Cuatro";
                    }
                    if (Elemento.equals("5")) {
                        CadenaValue = CadenaValue + "Cinco";
                    }
                    if (Elemento.equals("6")) {
                        CadenaValue = CadenaValue + "Seis";
                    }
                    if (Elemento.equals("7")) {
                        CadenaValue = CadenaValue + "Siete";
                    }
                    if (Elemento.equals("8")) {
                        CadenaValue = CadenaValue + "Ocho";
                    }
                    if (Elemento.equals("9")) {
                        CadenaValue = CadenaValue + "Nueve";
                    }
                }
                All = All + CadenaValue;
            }
            System.out.println(CadenaValue);
            CadenaValue = All;
            if (CadenaValue.trim().equals("Veinti")) {
                CadenaValue = "Veinte";
            }
            if (CadenaValue.length() >= 3 && CadenaValue.substring(CadenaValue.length() - 3, CadenaValue.length()).equals(" y ")) {
                CadenaValue = CadenaValue.substring(0, CadenaValue.length() - 3);
            }
            if (CadenaValue.equals("Un")) {
                CadenaValue = "Uno";
            }
            CadenaValue = CadenaValue + " " + CadenaCentavos + "/100 Dolares (US).";
            String CadenaValueCentavos = "";
            System.out.println(CadenaValue);
            CadenaValue = CadenaValue.substring(0, 1).toUpperCase() + CadenaValue.substring(1);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return CadenaValue.toLowerCase();
    }

    public String ConvertirFechaATexto(String cadena) {
        if (cadena.substring(5, 7).equals("01")) {
            return cadena.substring(8, 10) + " de Enero de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("02")) {
            return cadena.substring(8, 10) + " de Febrero de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("03")) {
            return cadena.substring(8, 10) + " de Marzo de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("04")) {
            return cadena.substring(8, 10) + " de Abril de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("05")) {
            return cadena.substring(8, 10) + " de Mayo de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("06")) {
            return cadena.substring(8, 10) + " de Junio de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("07")) {
            return cadena.substring(8, 10) + " de Julio de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("08")) {
            return cadena.substring(8, 10) + " de Agosto de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("09")) {
            return cadena.substring(8, 10) + " de Septiembre de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("10")) {
            return cadena.substring(8, 10) + " de Octubre de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("11")) {
            return cadena.substring(8, 10) + " de Noviembre de " + cadena.substring(0, 4);
        }
        if (cadena.substring(5, 7).equals("12")) {
            return cadena.substring(8, 10) + " de Diciembre de " + cadena.substring(0, 4);
        }
        return "";
    }

    public void crearSiguienteMes(Connection conn, String IdPeriodo, String IdEmpresa) {
        String mesSiguiente = "";
        int ano = Integer.parseInt(IdPeriodo.substring(0, 4));
        int mes = Integer.parseInt(IdPeriodo.substring(5, 7)) + 1;
        mesSiguiente = mes > 12 ? Integer.toString(ano + 1) + "01" : Integer.toString(ano) + this.RellenarCadena(Integer.toString(mes), 2, "I", "0");
        try {
            String sql = "insert into aco_periodos(Id_empresa,MES_CONTABLE)values(" + IdEmpresa + ",'" + mesSiguiente + "')";
            System.out.println(sql);
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (Exception e1) {
            System.out.println(e1);
        }
    }

    public boolean mesBloqueado(Connection conn, String IdPeriodo, String IdEmpresa) {
        String FechaNew = "";
        String sql = "SELECT * from aco_periodos where id_empresa = " + IdEmpresa + " and mes_contable = '" + IdPeriodo + "'";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FechaNew = rs.getString("activo");
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return FechaNew.equals("A");
    }

    public boolean existePeriodo(Connection conn, String IdPeriodo, String IdEmpresa) {
        boolean band = false;
        String sql = "SELECT * from aco_periodos where id_empresa = " + IdEmpresa + " and mes_contable = '" + IdPeriodo + "'";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                band = true;
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return band;
    }

    public String calcularSaldo(Connection conn, String idCosecha, String idLineaCredito, String idCliente, String fechaFin) throws Exception {
        String valor = "0.00";
        String sql = "SELECT SUM(CARGO) - SUM(ABONO_CAPITAL) AS SALDO FROM (  SELECT A.CARGO, A.ABONO_CAPITAL FROM CAF_PRESTAMOS_ABONOS A, CAF_COSECHAS B, CAF_PRODUCTORES C WHERE A.ID_COSECHA = B.ID_COSECHA  AND A.ID_PRODUCTOR = C.ID_PRODUCTOR AND A.ID_COSECHA = " + idCosecha + " " + "AND A.ID_PRODUCTOR = " + idCliente + " " + "AND A.FECHA <= '" + fechaFin + "' " + "AND A.ACTIVO = 'A' " + "AND A.ID_LINEA_CREDITO = " + idLineaCredito + " " + ") AS TABLA ";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            valor = this.FormatValue("#.##", rs.getDouble("saldo"));
        }
        rs.close();
        stmt.close();
        return valor;
    }

    public String calcularInteresAcumulado(Connection conn, String idCosecha, String idCliente, String fechaFin, String idLineaCredito) throws Exception {
        String valor = "0.00";
        String sql = "SELECT SUM(INTERESES) - SUM(ABONO_INTERESES) AS SALDO FROM (  SELECT A.INTERESES, A.ABONO_INTERESES FROM CAF_PRESTAMOS_ABONOS A, CAF_COSECHAS B, CAF_PRODUCTORES C WHERE A.ID_COSECHA = B.ID_COSECHA  AND A.ID_PRODUCTOR = C.ID_PRODUCTOR AND A.ID_COSECHA = " + idCosecha + " " + "AND A.ID_PRODUCTOR = " + idCliente + " " + "AND A.FECHA <= '" + fechaFin + "' " + "AND A.ACTIVO = 'A' " + "AND A.ID_LINEA_CREDITO = " + idLineaCredito + " " + ") AS TABLA ";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            valor = this.FormatValue("#.##", rs.getDouble("saldo"));
        }
        rs.close();
        stmt.close();
        return valor.replaceAll(",", "");
    }

    public String obtenerUltimaTransaccion(Connection conn, String idCosecha, String idCliente, String fecha, String idLineaCredito, String idAbono) throws Exception {
        String valor = "";
        String sql = "SELECT Max(FECHA) AS MAXIMO FROM CAF_PRESTAMOS_ABONOS A, CAF_COSECHAS B, CAF_PRODUCTORES C WHERE A.ID_COSECHA = B.ID_COSECHA  AND A.ID_PRODUCTOR = C.ID_PRODUCTOR AND A.ID_COSECHA = " + idCosecha + " " + "AND A.ID_PRODUCTOR = " + idCliente + " " + "AND A.FECHA <= '" + fecha + "' " + "AND A.ACTIVO = 'A' " + "AND A.ID_LINEA_CREDITO = " + idLineaCredito + " " + "and a.id_abono <> " + idAbono + " " + "order by fecha asc, id_abono asc" + "";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            valor = rs.getString("MAXIMO");
        }
        if (valor == null) {
            valor = fecha;
        }
        rs.close();
        stmt.close();
        return valor;
    }

    public static void setTableSorted(JTable jTable1, JTableHeader tj, int columnaOrden) {
        SortButtonRenderer buttonRenderer = new SortButtonRenderer();
        ((SortableTableModel)jTable1.getModel()).indexes = null;
        jTable1.repaint();
        buttonRenderer.setFont(new Font("Tahoma", 0, 13));
        TableColumnModel model = jTable1.getColumnModel();
        buttonRenderer.setSelectedColumn(columnaOrden);
        for (int i = 0; i < jTable1.getModel().getColumnCount(); ++i) {
            model.getColumn(i).setHeaderRenderer(buttonRenderer);
        }
        tj.addMouseListener(new HeaderListener(tj, buttonRenderer));
        tj.repaint();
    }

    public void loadIdTipoMovimiento(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT ID_TIPO_MOVIMIENTO as id, nombre_TIPO_MOVIMIENTO as nombre from CAF_ESPECIAL_TIPO_MOVIMIENTOS order by nombre_TIPO_MOVIMIENTO");
            while (rs.next()) {
                combo.addItem(new beansGenericoString(rs.getString("id"), rs.getString("nombre")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadIdFinca(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT ID_FINCA as id, nombre_FINCA as nombre from CAF_FINCAS order by nombre_finca");
            while (rs.next()) {
                combo.addItem(new beansGenericoString(rs.getString("id"), rs.getString("nombre")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadIdCalidad(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT ID_CALIDAD as id, nombre_CALIDAD as nombre from CAF_ESPECIAL_CALIDADES order by nombre_calidad");
            while (rs.next()) {
                combo.addItem(new beansGenericoString(rs.getString("id"), rs.getString("nombre")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadIdDestino(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT ID_DESTINO as id, nombre_DESTINO as nombre from CAF_ESPECIAL_DESTINOS order by nombre_Destino");
            while (rs.next()) {
                combo.addItem(new beansGenericoString(rs.getString("id"), rs.getString("nombre")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadIdCatacion(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT ID_CATACION as id, nombre_CATACION as nombre from CAF_ESPECIAL_CATACIONES order by nombre_catacion");
            while (rs.next()) {
                combo.addItem(new beansGenericoString(rs.getString("id"), rs.getString("nombre")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public static void START_TRANSACTION() {
        String sql = "start transaction";
        try {
            Statement stmt = FrameMain.conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (SQLException e1) {
            FrameMain.Ap.GetMessage(e1.toString(), 1, "");
        }
    }

    public static void COMMIT() {
        String sql = "COMMIT";
        try {
            Statement stmt = FrameMain.conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (SQLException e1) {
            FrameMain.Ap.GetMessage(e1.toString(), 1, "");
        }
    }

    public static void ROLLBACK() {
        String sql = "ROLLBACK";
        try {
            Statement stmt = FrameMain.conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
        }
        catch (SQLException e1) {
            FrameMain.Ap.GetMessage(e1.toString(), 1, "");
        }
    }

    public static Vector<beansGenericoString> cargarBeanDestinos(Connection conn, String textoPredeterminado) {
        String sql = "SELECT ID_DESTINO as id, nombre_DESTINO as nombre from CAF_ESPECIAL_DESTINOS order by nombre_Destino";
        Vector<beansGenericoString> bean = new Vector<beansGenericoString>();
        try {
            bean.add(new beansGenericoString("", textoPredeterminado));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                bean.add(new beansGenericoString(rs.getString("id"), rs.getString("nombre")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e1) {
            FrameMain.Ap.GetMessage(e1.toString(), 1, "");
        }
        return bean;
    }

    public void loadTiposCafes(Connection conn, JComboBox combo, String etiquetaPredeterminada, String clasificacion) {
        try {
            String sql = "SELECT ID_TIPO_CAFE as id, nombre_TIPO_CAFE as nombre, CASE CLASIFICACION WHEN 'U' THEN CONVERSION_ENTRADA ELSE CONVERSION_SECADO END AS CONVERSION from CAF_TIPOS_CAFES WHERE CLASIFICACION IN (" + clasificacion + ")";
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                beansGenericoString bean = new beansGenericoString(rs.getString("id"), rs.getString("nombre"));
                bean.setConversion(rs.getDouble("conversion"));
                combo.addItem(bean);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadCafExportacionesTipoProcesos(Connection conn, JComboBox IdTipoProcesoExportacion, String etiquetaPredeterminada) {
        try {
            IdTipoProcesoExportacion.addItem(new beansGenericoString("", etiquetaPredeterminada));
            String sql = "SELECT ID_TIPO_PROCESO_EXPORTACION as id, NOMBRE_TIPO_PROCESO_EXPORTACION as nombre from caf_exportaciones_tipo_procesos";
            PreparedStatement stmt = conn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                IdTipoProcesoExportacion.addItem(new beansGenericoString(rs.getString("id"), rs.getString("nombre")));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadTiposProyecciones(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            String sql = "SELECT ID_TIPO_PROYECCION, NOMBRE_TIPO_PROYECCION from CAF_TIPO_PROYECCIONES ";
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                beansGenericoString bean = new beansGenericoString(rs.getString("ID_TIPO_PROYECCION"), rs.getString("NOMBRE_TIPO_PROYECCION"));
                combo.addItem(bean);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadTiposExportaciones(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            String sql = "SELECT ID_TIPO, NOMBRE_TIPO_EXPORTACION from CAF_EXPORTACIONES_TIPOS where activo = 'A'";
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                beansGenericoString bean = new beansGenericoString(rs.getString("ID_TIPO"), rs.getString("NOMBRE_TIPO_EXPORTACION"));
                combo.addItem(bean);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public static void loadTiposExportaciones(Connection conn, Vector<beansGenericoString> beanTipoExportacion) {
        try {
            String sql = "SELECT ID_TIPO, NOMBRE_TIPO_EXPORTACION from CAF_EXPORTACIONES_TIPOS ";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                beansGenericoString bean = new beansGenericoString(rs.getString("ID_TIPO"), rs.getString("NOMBRE_TIPO_EXPORTACION"));
                beanTipoExportacion.add(bean);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadClaseCompras(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            String sql = "SELECT id_clase_compra, nombre_clase_compra from CAF_compras_clases ";
            combo.addItem(new beansComprasClases("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                beansComprasClases bean = new beansComprasClases(rs.getString("id_clase_compra"), rs.getString("nombre_clase_compra"));
                combo.addItem(bean);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadCosechas(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            String sql = "SELECT id_cosecha, nombre_cosecha from CAF_cosechas ";
            combo.addItem(new beansGenericoString("", etiquetaPredeterminada));
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                beansGenericoString bean = new beansGenericoString(rs.getString("id_cosecha"), rs.getString("nombre_cosecha"));
                combo.addItem(bean);
            }
            rs.close();
            stmt.close();
            combo.setSelectedItem(new beansGenericoString(FrameMain.idCosecha, ""));
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadPuertosEmbarque(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            String sql = "SELECT ID_PUERTO_EMBARQUE, NOMBRE_PUERTO_EMBARQUE from CAF_PUERTOS_EMBARQUE ";
            combo.addItem(etiquetaPredeterminada);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                combo.addItem(rs.getString("NOMBRE_PUERTO_EMBARQUE"));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadPuertosDestino(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            String sql = "SELECT ID_PUERTO_DESTINO, NOMBRE_PUERTO_DESTINO from CAF_PUERTOS_DESTINO ";
            combo.addItem(etiquetaPredeterminada);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                combo.addItem(rs.getString("NOMBRE_PUERTO_DESTINO"));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void loadPaisesDestino(Connection conn, JComboBox combo, String etiquetaPredeterminada) {
        try {
            String sql = "SELECT ID_PAIS_DESTINO, NOMBRE_PAIS_DESTINO from CAF_PAISES_DESTINO ";
            combo.addItem(etiquetaPredeterminada);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                combo.addItem(rs.getString("NOMBRE_PAIS_DESTINO"));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validarCalculoIntereses(Connection conn, String idCosecha, String idProductor, String idLineaCredito) {
        String sql = "SELECT a.fecha, a.id_cosecha, a.id_productor, b.nombre_productor, c.nombre_cosecha, a.dias FROM `caf_prestamos_abonos` a, caf_productores b, caf_cosechas c WHERE a.id_productor = b.id_productor and   a.id_cosecha = c.id_cosecha and   a.id_productor =  ? AND   a.id_cosecha = ? and   a.id_linea_credito = ? and   a.fecha >= '2016/01/01' ORDER BY a.fecha ASC, a.id_abono asc";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean band = false;
        int cont = 0;
        String fechaAnterior = "";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, idProductor);
            stmt.setString(2, idCosecha);
            stmt.setString(3, idLineaCredito);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (cont > 0 && this.ObtenerFechaMayor(fechaAnterior, rs.getString("fecha"), conn) != rs.getInt("dias")) {
                    band = true;
                    System.out.println("Cosecha: " + rs.getString("nombre_cosecha") + ", Productor:" + rs.getString("nombre_productor") + " - " + fechaAnterior + " Al " + rs.getString("fecha") + ": " + rs.getInt("dias"));
                    this.Ap.GetMessage("Error en Interes Cosecha: " + rs.getString("nombre_cosecha") + ", Productor:" + rs.getString("nombre_productor") + " - " + fechaAnterior + " Al " + rs.getString("fecha") + ": " + rs.getInt("dias"), 1, "");
                    break;
                }
                ++cont;
                fechaAnterior = rs.getString("fecha");
            }
        }
        catch (Exception e) {
            this.Ap.GetMessage(e.getMessage(), 1, "");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
        }
        return band;
    }

    public Map loadStmp(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select * from caf_smtp_config";
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                map.put("smtp", rs.getString("smtp"));
                map.put("puerto", rs.getString("puerto"));
                map.put("correo", rs.getString("correo"));
                map.put("contrasena", rs.getString("contrasena"));
                map.put("ssl", rs.getString("P_ssl"));
                map.put("ttls", rs.getString("P_ttls"));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            FrameMain.Ap.GetMessage(e.toString(), 1, "");
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean esReciboDuplicado(Connection conn, String idCosecha, String idPartida, String noRecibo) {
        String sql = "select * from caf_entradas where id_cosecha = ? and id_partida = ? and num_recibo = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean band = false;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, idCosecha);
            stmt.setString(2, idPartida);
            stmt.setString(3, noRecibo);
            rs = stmt.executeQuery();
            while (rs.next()) {
                band = true;
            }
        }
        catch (Exception e) {
            this.Ap.GetMessage(e.getMessage(), 1, "");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
        }
        return band;
    }

    public void ajustarColumnasTablas(JTable tabla) {
        for (int column = 0; column < tabla.getColumnCount(); ++column) {
            TableColumn tableColumn = tabla.getColumnModel().getColumn(column);
            int preferredWidth = tableColumn.getMinWidth();
            int maxWidth = tableColumn.getMaxWidth();
            for (int row = 0; row < tabla.getRowCount(); ++row) {
                TableCellRenderer cellRenderer = tabla.getCellRenderer(row, column);
                Component c = tabla.prepareRenderer(cellRenderer, row, column);
                int width = c.getPreferredSize().width + tabla.getIntercellSpacing().width;
                if ((preferredWidth = Math.max(preferredWidth, width)) < maxWidth) continue;
                preferredWidth = maxWidth;
                break;
            }
            tableColumn.setPreferredWidth(preferredWidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescripcionTipoCafe(Connection conn, String idTipoCafe) {
        String sql = "select descripcion from caf_tipos_cafes where id_tipo_cafe = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String val = "";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, idTipoCafe);
            rs = stmt.executeQuery();
            while (rs.next()) {
                val = rs.getString("descripcion");
            }
        }
        catch (Exception e) {
            this.Ap.GetMessage(e.getMessage(), 1, "");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
        }
        return val;
    }

    public void loadPreparacionesParaExportacion(Connection conn, JComboBox<beansPreparaciones> idPreparacion, String textoPredeterminado) {
        this.loadPreparaciones(conn, idPreparacion, textoPredeterminado, "MOSTRAR_EXPORTACION");
    }

    public void loadPreparacionesParaComprasUva(Connection conn, JComboBox<beansPreparaciones> idPreparacion, String textoPredeterminado) {
        this.loadPreparaciones(conn, idPreparacion, textoPredeterminado, "MOSTRAR_COMPRAS_UVA");
    }

    public void loadPreparaciones(Connection conn, JComboBox<beansPreparaciones> idPreparacion, String textoPredeterminado, String campo) {
        String sql = "select * from caf_Preparaciones where activo = 'A' and " + campo + " = true order by nombre_Preparacion ";
        idPreparacion.addItem(new beansPreparaciones("0", textoPredeterminado));
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                idPreparacion.addItem(new beansPreparaciones(rs.getString("id_preparacion"), rs.getString("nombre_preparacion")));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void loadPresentacionesVenta(Connection conn, JComboBox<beansPresentacionesVentas> idPresentacionVenta, String textoPredeterminado) {
        String sql = "select * from caf_presentaciones_venta where activo = 'A' ";
        idPresentacionVenta.addItem(new beansPresentacionesVentas("0", textoPredeterminado));
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                idPresentacionVenta.addItem(new beansPresentacionesVentas(rs.getString("id_presentacion_venta"), rs.getString("nombre_presentacion_venta")));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEquiposCapacidades(Connection conn, JComboBox<beansEquiposCapacidades> idEquipoCapacidad, String valorPredeterminado) {
        String sql = "select id_equipo_capacidad, descripcion, QQ_EQUIVALENCIA from caf_equipos_capacidades where activo = 'A' order by descripcion";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        beansEquiposCapacidades bean = new beansEquiposCapacidades();
        bean.setId("0");
        bean.setNombre(valorPredeterminado);
        bean.setConversion(0.0);
        idEquipoCapacidad.addItem(bean);
        try {
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                bean = new beansEquiposCapacidades();
                bean.setId(rs.getString(1));
                bean.setNombre(rs.getString(2));
                bean.setConversion(rs.getDouble(3));
                idEquipoCapacidad.addItem(bean);
            }
        }
        catch (Exception e) {
            this.Ap.GetMessage(e.getMessage(), 1, "");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTiposDocumentos(Connection conn, JComboBox<beansTipoDocumento> idTipoDocumento, String valorPredeterminado) {
        String sql = "select id_tipo_documento, nombre_tipo_documento from caf_tipos_documentos where modulo like '%C%'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        idTipoDocumento.addItem(new beansTipoDocumento("", valorPredeterminado));
        try {
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                idTipoDocumento.addItem(new beansTipoDocumento(rs.getString(1), rs.getString(2)));
            }
        }
        catch (Exception e) {
            this.Ap.GetMessage(e.getMessage(), 1, "");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
        }
    }

    public boolean esFechaValida(String fecha, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date d = null;
        try {
            d = sdf.parse(fecha);
        }
        catch (ParseException e) {
            return false;
        }
        return sdf.format(d).equals(fecha);
    }

    public static String convertDateToString(Date date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        String s = f.format(date);
        return s;
    }

    public static String convertDateToString(Date date) {
        try {
            return GeneralTools.convertDateToString(date, "yyyy/MM/dd");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static JTextField getDateToTextField(JDateChooser dateChooser) {
        return (JTextField)dateChooser.getDateEditor().getUiComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean existeViajeEntradasPorEquipo(Connection conn, String idCosecha, String idPartida, String idEquipo, String noViaje) {
        String sql = "select validarViajeEntradasPorEquipo(?,?,?,?) as band";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Boolean band = false;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, idCosecha);
            stmt.setString(2, idPartida);
            stmt.setString(3, noViaje);
            stmt.setString(4, idEquipo);
            rs = stmt.executeQuery();
            while (rs.next()) {
                band = rs.getBoolean(1);
            }
        }
        catch (Exception e) {
            this.Ap.GetMessage(e.getMessage(), 1, "");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
        }
        return band;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean esViajePorTarifaFija(Connection conn, String idCosecha, String idPartida, String idEquipo, String noViaje) {
        String sql = "SELECT tarifa_fija\n\tFROM `caf_entradas`\n\tWHERE id_cosecha = ?\n\tAND   id_partida = ?\n\tAND   no_viaje = ?\n\tLIMIT 1;";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Boolean band = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, idCosecha);
            stmt.setString(2, idPartida);
            stmt.setString(3, noViaje);
            rs = stmt.executeQuery();
            while (rs.next()) {
                band = rs.getBoolean(1);
            }
        }
        catch (Exception e) {
            this.Ap.GetMessage(e.getMessage(), 1, "");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    this.Ap.GetMessage(e.getMessage(), 1, "");
                }
            }
        }
        return band;
    }

    public static double TextFieldToDouble(JTextField jt) {
        return new Double(jt.getText().replaceAll(",", ""));
    }
}

