/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import Cafe.FrameMain;
import Tools.GeneralTools;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.view.JasperViewer;
import net.sf.jasperreports.view.JasperViewerDialog;

public class ReportManager {
    public void ExecuteReport(String ReportName, String formato, Map map, Connection conn, int param) {
        try {
            this.crearDirectorio();
            GeneralTools Gt = new GeneralTools();
            map.put("REPORT_LOCALE", Locale.US);
            map.put("logo", this.getClass().getResource("Imagenes/logo.png").openStream());
            map.put("reporteIntegral_1", this.getClass().getResource("Reportes/reporteIntegral_1.jasper").openStream());
            map.put("reporteIntegral_2", this.getClass().getResource("Reportes/reporteIntegral_2.jasper").openStream());
            map.put("reporteIntegral_3", this.getClass().getResource("Reportes/reporteIntegral_3.jasper").openStream());
            map.put("reporteIntegral_4", this.getClass().getResource("Reportes/reporteIntegral_4.jasper").openStream());
            map.put("reporteEntradasPorProductor_Detalle", this.getClass().getResource("Reportes/reporteEntradasPorProductor_Detalle.jasper").openStream());
            map.put("OC_1", this.getClass().getResource("Reportes/comprasOrdenCompraInventario.jasper").openStream());
            map.put("OC_2", this.getClass().getResource("Reportes/comprasOrdenCompraLocalInventario.jasper").openStream());
            String FechaImpresion = Gt.ObtenerFechaHora(0, conn);
            map.put("FechaImpresion", FechaImpresion.substring(8, 10) + "/" + FechaImpresion.substring(5, 7) + "/" + FechaImpresion.substring(0, 4));
            map.put("HoraImpresion", FechaImpresion.substring(10).trim());
            System.out.println(this.getClass().getResource("Reportes/" + ReportName + ".jasper").getPath());
            Object is = null;
            long tiempoInicial = System.currentTimeMillis();
            if (formato.equals("Excel")) {
                map.put("IS_IGNORE_PAGINATION", true);
                map.put("mostrarFirmas", "No");
            }
            JasperPrint jp = JasperFillManager.fillReport(this.getClass().getResource("Reportes/" + ReportName + ".jasper").openStream(), (Map<String, Object>)map, conn);
            if (formato.equals("Pdf")) {
                try {
                    JasperExportManager.exportReportToPdfFile(jp, Gt.DIRECCION_REPORTES + ReportName + ".pdf");
                    String[] command = new String[]{"cmd.exe", "/C", "Start", Gt.DIRECCION_REPORTES + ReportName + ".pdf"};
                    Process process = Runtime.getRuntime().exec(command);
                }
                catch (Exception e) {
                    FrameMain.Ap.GetMessage("El archivo se encuentra abierto pdf, favor cerrarlo.", 1, "");
                }
            }
            if (formato.equals("Excel")) {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    FileOutputStream outputfile = new FileOutputStream(new File(Gt.DIRECCION_REPORTES + ReportName + ".xls"));
                    JRXlsExporter exporterXLS = new JRXlsExporter();
                    exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, jp);
                    exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, outputfile);
                    exporterXLS.setParameter(JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);
                    exporterXLS.setParameter(JRXlsExporterParameter.IS_DETECT_CELL_TYPE, Boolean.TRUE);
                    exporterXLS.setParameter(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
                    exporterXLS.setParameter(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
                    exporterXLS.setParameter(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
                    exporterXLS.setParameter(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
                    exporterXLS.exportReport();
                    ((OutputStream)outputfile).close();
                    String[] command = new String[]{"cmd.exe", "/C", "Start", Gt.DIRECCION_REPORTES + ReportName + ".xls"};
                    Process process = Runtime.getRuntime().exec(command);
                }
                catch (Exception e) {
                    FrameMain.Ap.GetMessage("El archivo se encuentra abierto excel, favor cerrarlo.", 1, "");
                }
            }
            if (formato.equals("Vista")) {
                long tiempoFinal = System.currentTimeMillis();
                System.out.println(tiempoFinal - tiempoInicial);
                if (param == 2) {
                    JasperViewer.viewReport(jp, false);
                } else {
                    JasperPrintManager.printReport(jp, false);
                }
            }
            if (formato.equals("VistaDialog")) {
                if (param == 2) {
                    JasperViewerDialog.viewReport(jp, false);
                } else {
                    JasperPrintManager.printReport(jp, true);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private void crearDirectorio() {
        File f = new File(FrameMain.Gt.DIRECCION_REPORTES);
        if (!f.exists()) {
            f.mkdirs();
        }
    }
}

