/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import Tools.ApplicationMessages;
import Tools.GeneralTools;
import com.sun.mail.util.MailSSLSocketFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.security.Security;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JLabel;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;

public class mailClass {
    private GeneralTools Gt = new GeneralTools();
    private ApplicationMessages Ap = new ApplicationMessages();
    private String directorio = "c://Facturacion/Cotizaciones/";
    private String sender = "";
    private String password = "";
    private Map smtpConfig;
    private Connection conn;

    public mailClass(Connection conn) {
        this.conn = conn;
        this.smtpConfig = this.Gt.loadStmp(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSSLMessage(String[] recipients, ArrayList<File> attach, String subject, String mensaje, JLabel log) throws Exception {
        boolean debug = true;
        log.setText("Cargando configuraciones ...");
        if ("".equals(this.sender)) {
            this.sender = this.smtpConfig.get("correo").toString();
            this.password = this.smtpConfig.get("contrasena").toString();
        }
        Security.addProvider((java.security.Provider)new Provider());
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpConfig.get("smtp"));
        props.put("mail.smtp.port", this.smtpConfig.get("puerto"));
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", "true");
        if (this.smtpConfig.get("ssl").toString().equals("Si")) {
            MailSSLSocketFactory socketFactory = new MailSSLSocketFactory();
            socketFactory.setTrustAllHosts(true);
            props.put("mail.smtps.ssl.socketFactory", socketFactory);
            props.put("mail.smtp.socketFactory.port", this.smtpConfig.get("puerto"));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (this.smtpConfig.get("ttls").toString().equals("Si")) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        log.setText("Abriendo sesion ...");
        SMTPAuthenticator auth = new SMTPAuthenticator();
        Session session = Session.getDefaultInstance(props, auth);
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress addressFrom = new InternetAddress(this.sender);
        ((Message)msg).setFrom(addressFrom);
        Address[] addressTo = new InternetAddress[recipients.length];
        for (int i = 0; i < recipients.length; ++i) {
            addressTo[i] = new InternetAddress(recipients[i]);
        }
        ((Message)msg).setRecipients(Message.RecipientType.TO, addressTo);
        ((Message)msg).setSubject(subject);
        log.setText("Adjuntando archivos ...");
        System.out.println("inicio de atch");
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent("<p style=\"font-style:normal; font-size: 15px;\">" + mensaje + "</p>", "text/html");
        MimeBodyPart attachFilePart = new MimeBodyPart();
        MimeMultipart mp = new MimeMultipart();
        FileDataSource fds = null;
        for (int i = 0; i < attach.size(); ++i) {
            fds = null;
            fds = new FileDataSource(attach.get(i));
            attachFilePart = new MimeBodyPart();
            attachFilePart.setDataHandler(new DataHandler((DataSource)fds));
            attachFilePart.setFileName(fds.getName());
            ((Multipart)mp).addBodyPart(attachFilePart);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String dateInString = this.Gt.ObtenerFechaHora(0, this.conn);
        Date date = formatter.parse(dateInString);
        ((Message)msg).setSentDate(date);
        log.setText("Enviando correo electronico ...");
        ((Multipart)mp).addBodyPart(textPart);
        msg.setContent(mp);
        Transport.send(msg);
        log.setText("Guardando en carpeta de enviados ...");
        if (!"smtp.gmail.com".equals(this.smtpConfig.get("smtp").toString()) && !"smtp.zoho.com".equals(this.smtpConfig.get("smtp").toString())) {
            Store store = session.getStore("imap");
            store.connect(this.smtpConfig.get("smtp").toString(), this.sender, this.password);
            Folder folder = store.getFolder("INBOX.Sent");
            if (!folder.exists()) {
                folder.create(1);
            }
            folder.open(2);
            try {
                msg.setFlag(Flags.Flag.SEEN, true);
                folder.appendMessages(new Message[]{msg});
            }
            catch (Exception ignore) {
                System.out.println("error processing message " + ignore.getMessage());
            }
            finally {
                store.close();
            }
        }
        log.setText("Envio finalizado.");
    }

    public File ExecuteReport(String ReportName, Connection conn, String idOperacion) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("logo", this.getClass().getResource("/Farmacias/Imagenes/logoLemus.jpg").openStream());
            map.put("IdOperacion", idOperacion);
            JasperPrint jp = JasperFillManager.fillReport(this.getClass().getResource("Reportes/" + ReportName + ".jasper").openStream(), map, conn);
            JasperExportManager.exportReportToPdfFile(jp, this.directorio + "Cotizacion-" + idOperacion + ".pdf");
            return new File(this.directorio + "Cotizacion-" + idOperacion + ".pdf");
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public File ExecuteReportOrdenCompra(String ReportName, Connection conn, String idOperacion, String noOrden) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("IdOperacion", idOperacion);
            map.put("logo", this.getClass().getResource("/Farmacias/Imagenes/logoLemus.jpg").openStream());
            map.put("firma", this.getClass().getResource("/Farmacias/Imagenes/firma.png").openStream());
            JasperPrint jp = JasperFillManager.fillReport(this.getClass().getResource("Reportes/" + ReportName + ".jasper").openStream(), map, conn);
            JasperExportManager.exportReportToPdfFile(jp, this.directorio + "OrdenCompra-" + noOrden + ".pdf");
            return new File(this.directorio + "OrdenCompra-" + noOrden + ".pdf");
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private void crearDirectorio() {
        try {
            File f = new File(this.directorio);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(mailClass.this.sender, mailClass.this.password);
        }
    }
}

