/*
 * Decompiled with CFR 0.152.
 */
package calendar2.com.toedter.calendar;

import calendar2.com.toedter.calendar.JDayChooser;
import calendar2.com.toedter.calendar.JMonthChooser;
import calendar2.com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JCalendar
extends JPanel
implements PropertyChangeListener {
    private JYearChooser yearChooser = null;
    private JMonthChooser monthChooser = null;
    private JDayChooser dayChooser = null;
    private Calendar calendar;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public JCalendar() {
        this(0);
    }

    public JCalendar(int i) {
        this.calendar = Calendar.getInstance();
        this.setLayout(new BorderLayout());
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new GridLayout(1, 3));
        this.monthChooser = new JMonthChooser(i);
        this.yearChooser = new JYearChooser();
        this.monthChooser.setYearChooser(this.yearChooser);
        jpanel.add(this.monthChooser);
        jpanel.add(this.yearChooser);
        this.dayChooser = new JDayChooser();
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener(this);
        this.add((Component)jpanel, "North");
        this.add((Component)this.dayChooser, "Center");
        this.initialized = true;
    }

    private void setCalendar(Calendar calendar1, boolean flag) {
        Calendar calendar2 = this.calendar;
        this.calendar = calendar1;
        if (flag) {
            this.yearChooser.setYear(calendar1.get(1));
            this.monthChooser.setMonth(calendar1.get(2));
            this.dayChooser.setDay(calendar1.get(5));
        }
        this.firePropertyChange("calendar", calendar2, this.calendar);
    }

    public void setCalendar(Calendar calendar1) {
        this.setCalendar(calendar1, true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public void setLocale(Locale locale1) {
        if (!this.initialized) {
            super.setLocale(locale1);
        } else {
            Locale locale2 = this.locale;
            this.locale = locale1;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.firePropertyChange("locale", locale2, this.locale);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(color);
            this.monthChooser.setForeground(color);
            this.yearChooser.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(color);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        if (this.calendar != null) {
            Calendar calendar1 = (Calendar)this.calendar.clone();
            if (propertychangeevent.getPropertyName().equals("day")) {
                calendar1.set(5, (Integer)propertychangeevent.getNewValue());
                this.setCalendar(calendar1, false);
            } else if (propertychangeevent.getPropertyName().equals("month")) {
                calendar1.set(2, (Integer)propertychangeevent.getNewValue());
                this.setCalendar(calendar1, false);
            } else if (propertychangeevent.getPropertyName().equals("year")) {
                calendar1.set(1, (Integer)propertychangeevent.getNewValue());
                this.setCalendar(calendar1, false);
            }
        }
    }

    @Override
    public String getName() {
        return "JCalendar";
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame("JCalendar");
        jframe.getContentPane().add(new JCalendar());
        jframe.pack();
        jframe.setVisible(true);
    }
}

