/*
 * Decompiled with CFR 0.152.
 */
package calendar2.com.toedter.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private JButton[] days;
    private JButton selectedDay = null;
    private int day;
    private Color oldDayBackgroundColor;
    private Color selectedColor;
    private Color colorRed;
    private Color colorBlue;
    private String[] dayNames;
    private Calendar calendar;
    private Calendar today;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public JDayChooser() {
        this.days = new JButton[49];
        Calendar calendar1 = Calendar.getInstance(this.locale);
        this.today = (Calendar)calendar1.clone();
        this.setLayout(new GridLayout(7, 7));
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int k = j + 7 * i;
                if (i == 0) {
                    this.days[k] = new JButton(){

                        @Override
                        public void addMouseListener(MouseListener mouselistener) {
                        }

                        @Override
                        public boolean isFocusable() {
                            return false;
                        }
                    };
                    this.days[k].setBackground(new Color(180, 180, 200));
                } else {
                    this.days[k] = new JButton("x");
                    this.days[k].addActionListener(this);
                    this.days[k].addKeyListener(this);
                    this.days[k].addFocusListener(this);
                }
                this.days[k].setMargin(new Insets(0, 0, 0, 0));
                this.days[k].setFocusPainted(false);
                this.days[k].setBorderPainted(false);
                this.add(this.days[k]);
            }
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.initialized = true;
    }

    protected void init() {
        this.colorRed = new Color(164, 0, 0);
        this.colorBlue = new Color(0, 0, 164);
        JButton jbutton = new JButton();
        this.oldDayBackgroundColor = jbutton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        this.calendar = Calendar.getInstance(this.locale);
        int i = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateformatsymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateformatsymbols.getShortWeekdays();
        int j = i;
        for (int k = 0; k < 7; ++k) {
            this.days[k].setText(this.dayNames[j]);
            if (j == 1) {
                this.days[k].setForeground(this.colorRed);
            } else {
                this.days[k].setForeground(this.colorBlue);
            }
            if (j < 7) {
                ++j;
                continue;
            }
            j -= 6;
        }
        this.drawDays();
    }

    protected void drawDays() {
        int k;
        Calendar calendar1 = (Calendar)this.calendar.clone();
        int i = calendar1.getFirstDayOfWeek();
        calendar1.set(5, 1);
        int j = calendar1.get(7) - i;
        if (j < 0) {
            j += 7;
        }
        for (k = 0; k < j; ++k) {
            this.days[k + 7].setVisible(false);
            this.days[k + 7].setText("");
        }
        calendar1.add(2, 1);
        Date date = calendar1.getTime();
        calendar1.add(2, -1);
        Date date1 = calendar1.getTime();
        int l = 0;
        Color color = this.getForeground();
        while (date1.before(date)) {
            this.days[k + l + 7].setText(Integer.toString(l + 1));
            this.days[k + l + 7].setVisible(true);
            if (calendar1.get(6) == this.today.get(6) && calendar1.get(1) == this.today.get(1)) {
                this.days[k + l + 7].setForeground(this.colorRed);
            } else {
                this.days[k + l + 7].setForeground(color);
            }
            if (l + 1 == this.day) {
                this.days[k + l + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[k + l + 7];
            } else {
                this.days[k + l + 7].setBackground(this.oldDayBackgroundColor);
            }
            ++l;
            calendar1.add(5, 1);
            date1 = calendar1.getTime();
        }
        for (int i1 = l + k + 7; i1 < 49; ++i1) {
            this.days[i1].setVisible(false);
            this.days[i1].setText("");
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale1) {
        if (!this.initialized) {
            super.setLocale(locale1);
        } else {
            this.locale = locale1;
            this.init();
        }
    }

    public void setDay(int i) {
        if (i < 1) {
            i = 1;
        }
        Calendar calendar1 = (Calendar)this.calendar.clone();
        calendar1.set(5, 1);
        calendar1.add(2, 1);
        calendar1.add(5, -1);
        int j = calendar1.get(5);
        if (i > j) {
            i = j;
        }
        int k = this.day;
        this.day = i;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        for (int l = 7; l < 49; ++l) {
            if (!this.days[l].getText().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[l];
            this.selectedDay.setBackground(this.selectedColor);
            break;
        }
        this.firePropertyChange("day", k, this.day);
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int i) {
        this.calendar.set(2, i);
        this.setDay(this.day);
        this.drawDays();
    }

    public void setYear(int i) {
        this.calendar.set(1, i);
        this.drawDays();
    }

    public void setCalendar(Calendar calendar1) {
        this.calendar = calendar1;
        this.drawDays();
    }

    @Override
    public void setFont(Font font) {
        if (this.days != null) {
            for (int i = 0; i < 49; ++i) {
                this.days[i].setFont(font);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.days != null) {
            for (int i = 7; i < 49; ++i) {
                this.days[i].setForeground(color);
            }
            this.drawDays();
        }
    }

    @Override
    public String getName() {
        return "JDayChooser";
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        JButton jbutton = (JButton)actionevent.getSource();
        String s = jbutton.getText();
        int i = new Integer(s);
        this.setDay(i);
    }

    @Override
    public void focusGained(FocusEvent focusevent) {
        JButton jbutton = (JButton)focusevent.getSource();
        String s = jbutton.getText();
        if (s != null && !s.equals("")) {
            this.actionPerformed(new ActionEvent(focusevent.getSource(), 0, null));
        }
    }

    @Override
    public void focusLost(FocusEvent focusevent) {
    }

    @Override
    public void keyPressed(KeyEvent keyevent) {
        int byte0;
        int n = keyevent.getKeyCode() != 38 ? (keyevent.getKeyCode() != 40 ? (keyevent.getKeyCode() != 37 ? (int)(keyevent.getKeyCode() == 39 ? 1 : 0) : -1) : 7) : (int)(byte0 = -7);
        if (byte0 != 0) {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                if (this.getComponent(i) != this.selectedDay) continue;
                if ((i += byte0) <= 7 || i >= this.days.length || !this.days[i].isVisible()) break;
                this.days[i].requestFocus();
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyevent) {
    }

    @Override
    public void keyReleased(KeyEvent keyevent) {
    }

    public void setDayBorderPainted(boolean flag) {
        for (int i = 0; i < this.days.length; ++i) {
            if (this.days[i] == null) continue;
            this.days[i].setBorderPainted(flag);
        }
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame("JDayChooser");
        jframe.getContentPane().add(new JDayChooser());
        jframe.pack();
        jframe.setVisible(true);
    }
}

