/*
 * Decompiled with CFR 0.152.
 */
package calendar2.gnu.gui.datepicker;

import calendar2.gnu.gui.datepicker.EditorSupport;
import calendar2.gnu.gui.datepicker.JDateTextField;
import calendar2.gnu.gui.datepicker.JDialogDatePicker;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class DateCellEditor
extends JDateTextField
implements TableCellEditor,
MouseListener,
KeyListener {
    JDialogDatePicker datePicker;
    protected EditorSupport _support;
    protected Object _startVal;
    protected String _startString;
    protected DateFormat _dateFormat;

    public DateCellEditor() {
        this.allowNullDate(true);
        this.setDefaultType(2);
        this._support = new EditorSupport(this){

            @Override
            public boolean stopCellEditing() {
                if (!DateCellEditor.this.stopCellEditing()) {
                    System.out.println("<>.stopCellEditing() date is bad");
                    DateCellEditor.this.setText(new Date());
                    DateCellEditor.access$7000071(DateCellEditor.this);
                } else if (DateCellEditor.this.getText().length() >= 10) {
                    DateCellEditor.this.setText(DateCellEditor.this.getText().substring(0, 10));
                    System.out.println("<>.stopCellEditing() date is good");
                } else {
                    DateCellEditor.this.setText(new Date());
                    System.out.println("<>.stopCellEditing() date is bad");
                    DateCellEditor.access$7000071(DateCellEditor.this);
                }
                DateCellEditor.this.setCaretPosition(0);
                return super.stopCellEditing();
            }
        };
        this.datePicker = new JDialogDatePicker(this);
        this.addActionListener(this._support);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setToolTipText("Press Alt + C or popup mouse button to display calendar");
        this.setCaretPosition(0);
    }

    public DateCellEditor(String format) {
        this();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        this.setDateFormat(sdf);
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public void setDateFormat(DateFormat df) {
        this._dateFormat = df;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            return this;
        }
        this._startString = this._dateFormat.format(value);
        this.setText(this._startString);
        this._startVal = value;
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        Object date;
        try {
            date = this._dateFormat.parse(this.getText());
        }
        catch (ParseException e) {
            date = this._startVal;
        }
        return date;
    }

    @Override
    public void cancelCellEditing() {
        this.setText(this._startString);
        this._support.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject eo) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eo) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            Date date = this._dateFormat.parse(this.getText());
        }
        catch (ParseException e) {
            boolean flag;
            boolean bool = flag = false;
            return bool;
        }
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cel) {
        this._support.addCellEditorListener(cel);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cel) {
        this._support.removeCellEditorListener(cel);
    }

    protected void msgBox(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent1) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent1) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent1) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.datePicker.setLocation(this.getLocationOnScreen());
            try {
                this.datePicker.setCalendar(this.getCalendar());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.datePicker.setVisible(true);
            this.setDate(this.datePicker.getDate());
            this.fireActionPerformed();
            e.getComponent().requestFocus();
        }
    }

    private void maybeShowPopup(KeyEvent e) {
        if (e.isAltDown() && e.getKeyCode() == 67) {
            try {
                this.datePicker.setCalendar(this.getCalendar());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.datePicker.setLocation(this.getLocationOnScreen());
            this.datePicker.setVisible(true);
            this.setDate(this.datePicker.getDate());
            this.fireActionPerformed();
            e.getComponent().requestFocus();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void keyTyped(KeyEvent keyevent1) {
    }

    static void access$7000071(DateCellEditor this$) {
        this$.fireActionPerformed();
    }
}

