/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FieldComparatorFactory;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.EvaluationType;
import net.sf.jasperreports.engine.fill.DatasetFillContext;

public class FieldFilter
implements DatasetFilter {
    private final String field;
    private String filterValueStart;
    private String filterValueEnd;
    private String filterType;
    private String filterTypeOperator;
    private String filterPattern;
    private DatasetFillContext context;
    private Boolean isValid;
    private FilterTypesEnum filterTypeEnum;
    private AbstractFieldComparator<?> fieldComparator;

    public FieldFilter(String field, String filterValueStart, String filterValueEnd, String filterType, String filterTypeOperator) {
        this.field = field;
        this.filterValueStart = filterValueStart;
        this.filterValueEnd = filterValueEnd;
        this.filterType = filterType;
        this.filterTypeOperator = filterTypeOperator;
    }

    public void init(DatasetFillContext context) {
        this.context = context;
        this.filterTypeEnum = FilterTypesEnum.getByName(this.filterType);
        if (this.fieldComparator == null) {
            this.fieldComparator = FieldComparatorFactory.createFieldComparator(this.filterTypeEnum, this.filterPattern, context.getLocale() != null ? context.getLocale() : Locale.getDefault(), (TimeZone)context.getParameterValue("REPORT_TIME_ZONE"));
        }
    }

    public boolean matches(EvaluationType evaluation) {
        Object value = this.context.getFieldValue(this.field, evaluation);
        if (value == null) {
            return false;
        }
        this.fieldComparator.setValueStart(this.filterValueStart);
        this.fieldComparator.setValueEnd(this.filterValueEnd);
        this.fieldComparator.setCompareTo(value);
        if (this.isValid == null) {
            this.isValid = this.fieldComparator.isValid();
        }
        if (!this.isValid.booleanValue()) {
            return true;
        }
        return this.fieldComparator.compare(this.filterTypeOperator);
    }

    public String getField() {
        return this.field;
    }

    public String getFilterValueStart() {
        return this.filterValueStart;
    }

    public void setFilterValueStart(String filterValueStart) {
        this.filterValueStart = filterValueStart;
    }

    public String getFilterValueEnd() {
        return this.filterValueEnd;
    }

    public void setFilterValueEnd(String filterValueEnd) {
        this.filterValueEnd = filterValueEnd;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public String getFilterTypeOperator() {
        return this.filterTypeOperator;
    }

    public void setFilterTypeOperator(String filterTypeOperator) {
        this.filterTypeOperator = filterTypeOperator;
    }

    public FilterTypesEnum getFilterTypeEnum() {
        return this.filterTypeEnum;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }
}

