/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRSimpleTemplate
implements JRTemplate,
Serializable,
JRChangeEventsSupport {
    public static final String PROPERTY_STYLE = "style";
    public static final String PROPERTY_INCLUDED_TEMPLATES = "incluldedTemplates";
    private static final long serialVersionUID = 10200L;
    private final List<JRTemplateReference> includedTemplates = new ArrayList<JRTemplateReference>();
    private final List<JRStyle> styles = new ArrayList<JRStyle>();
    private JRStyle defaultStyle;
    private transient JRPropertyChangeSupport eventSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRSimpleTemplate jRSimpleTemplate = this;
        synchronized (jRSimpleTemplate) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public void addStyle(JRStyle style) throws JRException {
        this.addStyle(-1, style);
    }

    public void addStyle(int index, JRStyle style) throws JRException {
        this.checkExistingName(style.getName());
        if (style.isDefault()) {
            this.defaultStyle = style;
        }
        if (index >= 0 && index < this.styles.size()) {
            this.styles.add(index, style);
        } else {
            this.styles.add(style);
            index = this.styles.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_STYLE, style, index);
    }

    protected void checkExistingName(String name) throws JRException {
        if (this.getStyle(name) != null) {
            throw new JRException("Duplicate declaration of template style : " + name);
        }
    }

    protected boolean nameMatches(JRStyle style, String name) {
        String styleName = style.getName();
        return name == null ? styleName == null : name.equals(styleName);
    }

    public JRStyle getStyle(String name) {
        JRStyle style = null;
        for (JRStyle itStyle : this.styles) {
            if (!this.nameMatches(itStyle, name)) continue;
            style = itStyle;
            break;
        }
        return style;
    }

    public boolean removeStyle(JRStyle style) {
        int idx = this.styles.indexOf(style);
        if (idx >= 0) {
            this.styles.remove(idx);
            if (style.isDefault()) {
                this.defaultStyle = null;
            }
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_STYLE, style, idx);
            return true;
        }
        return false;
    }

    public JRStyle removeStyle(String name) {
        JRStyle removed = null;
        ListIterator<JRStyle> it = this.styles.listIterator();
        while (it.hasNext()) {
            JRStyle style = it.next();
            if (!this.nameMatches(style, name)) continue;
            if (style.isDefault()) {
                this.defaultStyle = null;
            }
            removed = style;
            break;
        }
        this.removeStyle(removed);
        return removed;
    }

    public List<JRStyle> getStylesList() {
        return this.styles;
    }

    @Override
    public JRStyle[] getStyles() {
        return this.styles.toArray(new JRStyle[this.styles.size()]);
    }

    @Override
    public JRStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void addIncludedTemplate(int index, JRTemplateReference reference) {
        if (index >= 0 && index < this.includedTemplates.size()) {
            this.includedTemplates.add(index, reference);
        } else {
            this.includedTemplates.add(reference);
            index = this.includedTemplates.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_INCLUDED_TEMPLATES, reference, index);
    }

    public void addIncludedTemplate(JRTemplateReference reference) {
        this.addIncludedTemplate(-1, reference);
    }

    public void addIncludedTemplate(String templateLocation) {
        this.addIncludedTemplate(new JRTemplateReference(templateLocation));
    }

    public boolean removeIncludedTemplate(JRTemplateReference reference) {
        int idx = this.includedTemplates.indexOf(reference);
        if (idx >= 0) {
            this.includedTemplates.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_INCLUDED_TEMPLATES, reference, idx);
            return true;
        }
        return false;
    }

    public JRTemplateReference removeIncludedTemplate(String location) {
        JRTemplateReference removed = null;
        ListIterator<JRTemplateReference> it = this.includedTemplates.listIterator();
        while (it.hasNext()) {
            JRTemplateReference ref = it.next();
            if (!ref.getLocation().equals(location)) continue;
            removed = ref;
        }
        this.removeIncludedTemplate(removed);
        return removed;
    }

    @Override
    public JRTemplateReference[] getIncludedTemplates() {
        return this.includedTemplates.toArray(new JRTemplateReference[this.includedTemplates.size()]);
    }

    public List<JRTemplateReference> getIncludedTemplatesList() {
        return this.includedTemplates;
    }
}

