/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRXlsExporter;

class BoxStyle {
    protected static final int TOP = 0;
    protected static final int LEFT = 1;
    protected static final int BOTTOM = 2;
    protected static final int RIGHT = 3;
    protected short[] borderStyle = new short[4];
    protected short[] borderColour = new short[4];
    private int hash;

    public BoxStyle(int side, JRPen pen) {
        this.borderStyle[side] = JRXlsExporter.getBorderStyle(pen);
        this.borderColour[side] = JRXlsExporter.getWorkbookColor(pen.getLineColor()).getIndex();
        this.hash = this.computeHash();
    }

    public BoxStyle(JRExporterGridCell gridCell) {
        JRPrintElement element;
        JRLineBox lineBox = gridCell.getBox();
        if (lineBox != null) {
            this.setBox(lineBox);
        }
        if ((element = gridCell.getElement()) instanceof JRCommonGraphicElement) {
            this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
        }
        this.hash = this.computeHash();
    }

    public void setBox(JRLineBox box) {
        this.borderStyle[0] = JRXlsExporter.getBorderStyle(box.getTopPen());
        this.borderColour[0] = JRXlsExporter.getWorkbookColor(box.getTopPen().getLineColor()).getIndex();
        this.borderStyle[2] = JRXlsExporter.getBorderStyle(box.getBottomPen());
        this.borderColour[2] = JRXlsExporter.getWorkbookColor(box.getBottomPen().getLineColor()).getIndex();
        this.borderStyle[1] = JRXlsExporter.getBorderStyle(box.getLeftPen());
        this.borderColour[1] = JRXlsExporter.getWorkbookColor(box.getLeftPen().getLineColor()).getIndex();
        this.borderStyle[3] = JRXlsExporter.getBorderStyle(box.getRightPen());
        this.borderColour[3] = JRXlsExporter.getWorkbookColor(box.getRightPen().getLineColor()).getIndex();
        this.hash = this.computeHash();
    }

    public void setPen(JRPen pen) {
        if (this.borderStyle[0] == 0 && this.borderStyle[1] == 0 && this.borderStyle[2] == 0 && this.borderStyle[3] == 0) {
            short style = JRXlsExporter.getBorderStyle(pen);
            short colour = JRXlsExporter.getWorkbookColor(pen.getLineColor()).getIndex();
            this.borderStyle[0] = style;
            this.borderStyle[2] = style;
            this.borderStyle[1] = style;
            this.borderStyle[3] = style;
            this.borderColour[0] = colour;
            this.borderColour[2] = colour;
            this.borderColour[1] = colour;
            this.borderColour[3] = colour;
        }
        this.hash = this.computeHash();
    }

    private int computeHash() {
        int hashCode = this.borderStyle[0];
        hashCode = 31 * hashCode + this.borderColour[0];
        hashCode = 31 * hashCode + this.borderStyle[2];
        hashCode = 31 * hashCode + this.borderColour[2];
        hashCode = 31 * hashCode + this.borderStyle[1];
        hashCode = 31 * hashCode + this.borderColour[1];
        hashCode = 31 * hashCode + this.borderStyle[3];
        hashCode = 31 * hashCode + this.borderColour[3];
        return hashCode;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        BoxStyle b = (BoxStyle)o;
        return b.borderStyle[0] == this.borderStyle[0] && b.borderColour[0] == this.borderColour[0] && b.borderStyle[2] == this.borderStyle[2] && b.borderColour[2] == this.borderColour[2] && b.borderStyle[1] == this.borderStyle[1] && b.borderColour[1] == this.borderColour[1] && b.borderStyle[3] == this.borderStyle[3] && b.borderColour[3] == this.borderColour[3];
    }

    public String toString() {
        return "(" + this.borderStyle[0] + "/" + this.borderColour[0] + "," + this.borderStyle[2] + "/" + this.borderColour[2] + "," + this.borderStyle[1] + "/" + this.borderColour[1] + "," + this.borderStyle[3] + "/" + this.borderColour[3] + ")";
    }
}

