/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDoubleAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleCountIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleSumIncrementer;
import net.sf.jasperreports.engine.fill.JRDoubleVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRDoubleIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Double ZERO = new Double(0.0);
    private static JRDoubleIncrementerFactory mainInstance = new JRDoubleIncrementerFactory();

    private JRDoubleIncrementerFactory() {
    }

    public static JRDoubleIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case COUNT: {
                incrementer = JRDoubleCountIncrementer.getInstance();
                break;
            }
            case SUM: {
                incrementer = JRDoubleSumIncrementer.getInstance();
                break;
            }
            case AVERAGE: {
                incrementer = JRDoubleAverageIncrementer.getInstance();
                break;
            }
            case LOWEST: 
            case HIGHEST: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                incrementer = JRDoubleStandardDeviationIncrementer.getInstance();
                break;
            }
            case VARIANCE: {
                incrementer = JRDoubleVarianceIncrementer.getInstance();
                break;
            }
            case DISTINCT_COUNT: {
                incrementer = JRDoubleDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

